// parenthesis_check.cpp: implementation of the parenthesis_check class.
//
//////////////////////////////////////////////////////////////////////

#include <fstream.h>
#include "parenthesis_check.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//Default Constructor
parenthesis_check::parenthesis_check() : str(NULL) , str_size(0)
{	
	STACK<char>();
}

//Destructor
parenthesis_check::~parenthesis_check()
{	
	if (str!=NULL)
		delete[] str;	
}

//Copy Constructor
parenthesis_check:: parenthesis_check(parenthesis_check& rhs)
{
	if (str!=NULL)
		delete str;

	str=new char[rhs.str_size];
	str_size=rhs.str_size;

	for (int i=0 ; i<str_size ; i++)
	{
		str[i]=rhs.str[i];
	}
}

//Assignment Operator
parenthesis_check parenthesis_check:: operator=(parenthesis_check& rhs)
{
	if (str!=NULL)
		delete str;

	str=new char[rhs.str_size];
	str_size=rhs.str_size;

	for (int i=0 ; i<str_size ; i++)
	{
		str[i]=rhs.str[i];
	}

	return (*this);
}


//Check string function that checks that the sting is balanced or not by using the stack

//bool returns that the string is balanced or not

bool parenthesis_check:: check_string()
{
	bool check=true;
	int pop_check=0;

	for (int i=0 ; i<str_size ; i++)
	{
		pop_check=0;

		// if left parenthesis is found , push it on the stack
		if ((str[i]=='{')||(str[i]=='(')||(str[i]=='[')||(str[i]=='/'))
		{
			if ((str[i]=='{')||(str[i]=='(')||(str[i]=='['))
				left_parenthesis.Push(str[i]);					
			
			else if ((str[i]=='/')&&(str[i+1]=='*'))
				left_parenthesis.Push(str[i+1]);										
		}

		// else if the right parenthesis is found then checks the top parenthesis of the stack
		// and if it matches , then pop it from the stack

		else if ((str[i]=='}')||(str[i]==')')||(str[i]==']')||(str[i]=='*'))
		{
			if ((str[i]=='}')&&(left_parenthesis.Peek()=='{'))
				pop_check=1;

			else if ((str[i]==']')&&(left_parenthesis.Peek()=='['))
				pop_check=1;			

			else if ((str[i]==')')&&(left_parenthesis.Peek()=='('))
				pop_check=1;

			else if ((str[i]=='*')&&(str[i+1]=='/')&&(left_parenthesis.Peek()=='*'))
				pop_check=1;			

			if (pop_check==1)
			{
				left_parenthesis.Pop();				
				check=true;
			}	
			else 
				check=false;
		}		
	}

	// if the stack is empty means that the stack is empty
	if ((left_parenthesis.Get_Size()==0)&&(check==true))
		return true;
	
	return false;
}

//overloaded stream insertion operator that is used by the Parenthesis class to take the input from the file

istream &operator>>(istream &input, parenthesis_check& p)
{
	int counter=0;
	char char_counter;
	
	while(input>>char_counter)
	{
		++counter;					// checks the number of characters in the given string
	}	

	p.str=new char[counter+1];
	p.str_size=counter+1;

	input.clear();
	input.seekg(0);	

	input>>p.str;

	p.left_parenthesis.ReAllocate(counter);
	
	return input;
}

//overloaded stream extraction operator that is used by the Parenthesis class to print the string to the file

ostream &operator<< (ostream &output, parenthesis_check& p)
{	
	output<<p.str;
	return output;
}
